* Title: Better User Roles
* Slug: improved-user-roles

================================================================

In activeCollab 4, the <{term}>System Roles<{/term}> have been made **more simple and straightforward**. There are now five system roles  - <{term}>Administrator<{/term}>, <{term}>Manager<{/term}>, <{term}>Member/Employee<{/term}>, <{term}>Subcontractor<{/term}> and <{term}>Client<{/term}>. The core permissions for these roles are predefined and cannot be edited, but there is a number of extra permissions you can add to each role.

<{note title="Who Can See Private Objects?"}>**Clients are the only users who cannot see Private Objects** in activeCollab. 

For example, if a discussion is marked as private, only your team and subcontractors will be able to see that discussion and to participate in it. This is how you can make some conversations with your team invisible to your clients.<{/note}>

What follows is a brief description of each role and the related system permissions:

<{sub}>Administrator<{/sub}>

This role is reserved for power users, who are meant to have full unrestricted access to the system. By default, **all areas of activeCollab are accessible to administrator users**, except for finances. <{option}>Manage Finances<{/option}> and <{option}>Manage Quotes<{/option}> are available as extra permissions, and have to be enabled manually.

<{sub}>Manager<{/sub}>

Managers, without any additional permissions, will only be able to see projects they work on and the <{term}>Assignments<{/term}> report. With this role, **extra permissions determine which area of responsibility is assigned to the Manager**. For example, the <{option}>Manage People<{/option}> permission allow the manager to edit all user and company information (excluding administrators), the <{option}>Manage Projects<{/option}> permission gives unrestricted access to all the projects, etc. 

This role is intended for users who need to have unrestricted access to certain sections of activeCollab along with their respective reports. 

<{image name='roles.png'}>

<{sub}>Member/Employee<{/sub}>

Most of your **team members** will probably have this user role. These users **can only access projects that they are working on**. They need additional permissions to <{option}>Create New Projects<{/option}> or to <{option}>See the Project Budget<{/option}>. 

There are also a few additional permissions, which will enable them to use <{term}>Documents<{/term}> or <{term}>Status Updates<{/term}>). However, it is not possible to allow employees to access confidential information in your activeCollab by using reporting or finance tools. 

<{sub}>Subcontractor<{/sub}>

This role is created for **users who are not a part of your company or organization but are included in the project as external associates**. 

The main difference between subcontractors and your employees role is in additional permissions that are unavailable to your subcontractors - these users cannot  <{option}>See Project Budgets<{/option}> or to <{option}>See Company Notes<{/option}>. Also, by default, the contact details of these users will not be displayed to your clients, and vice versa.

<{sub}>Client<{/sub}>

The Client role has been made the most restrictive to prevent access to any private information, but is still flexible enough to alloe your client to see essential info for their projects in your activeCollab. 

**Clients will only see projects they are assigned to without any other data**. They can be given extra permissions to <{option}>Submit Project Requests<{/option}>, <{option}>Use Global Documents<{/option}> and <{option}>Receive and Pay Invoices<{/option}>.